/* $Id: srcspanbs.c,v 1.4 1998/07/20 22:40:48 ericb Exp $ */
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

/* exmple of how to set source blocksize and spans different than the
   inputs */

#include <stdio.h>		/* For printf */
#include <unistd.h>		/* For sleep */
#include <sicl.h>		/* For SICL functions */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

#define	BLOCKSIZE	8196
#define	IN_MAX		32
#define	SRC_MAX		5
#define	NUM_MODULES	2
#define	MODULE1_ADDR	8
#define	MODULE2_ADDR	9
 
/* Make these global so various routines can get to them easily */
static E1432ID hw;
static SHORTSIZ16 group;
static SHORTSIZ16 chan_list[IN_MAX + SRC_MAX];
static int chan_count;

static SHORTSIZ16 in_list[IN_MAX];
static SHORTSIZ16 in_group;
static int in_count;

static SHORTSIZ16 src_list[SRC_MAX];
static SHORTSIZ16 src_group;
static int src_count;

static FLOATSIZ64 buffer[BLOCKSIZE];

static int
read_data(void)
{
    LONGSIZ32 count;
    int     i;

    /* Read some data */
    for (i = 0; i < in_count; i++)
    {
	CHECK(e1432_read_float64_data(hw, in_list[i],
				      E1432_TIME_DATA, buffer,
				      BLOCKSIZE, NULL, &count));
	 (void) printf("channel %d    data points read =  %d\n", i , count);
    }
    return 0;
}

int
main(void)
{
    int     i, error, blockcountmax, scan, status;
    int	armmode, trigmode, wait, nowait;
    int srcspan, srcblocksize;

    struct e1432_hwconfig hwconfig[NUM_MODULES];
    SHORTSIZ16 laddr[NUM_MODULES];

    laddr[0] = MODULE1_ADDR;
    laddr[1] = MODULE2_ADDR;

    wait = 1;
    nowait = 0;
    
    /* Initialize the library */
    CHECK(e1432_init_io_driver());

    /* Change this 0 to 1 to see call tracing */
    e1432_trace_level(0);

    /* Install sema.bin if needed */
    status = e1432_get_hwconfig(2, laddr, hwconfig);
    CHECK(e1432_print_errors(1));
    if (status < 0)
    {
        CHECK(e1432_install(2, laddr, 0, "/opt/e1432/lib/sema.bin"));
        CHECK(e1432_get_hwconfig(2, laddr, hwconfig));
    }

    /* Turn on debugging prints, a good idea while developing.  But do
       it after the above e1432_get_hwconfig, because we know that
       might error if the firmware is not yet installed in the
       module. */
    (void) e1432_print_errors(1);

    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(NUM_MODULES, laddr, &hw));

    /* Create input channel group */
    in_count = hwconfig[0].input_chans + hwconfig[1].input_chans;
    (void) printf("Input channels = %d\n", in_count);
    if ( in_count > 0)
    {
	if (in_count > IN_MAX)
	    in_count = IN_MAX;
	for (i = 0; i < in_count; i++)
	    in_list[i] = E1432_INPUT_CHAN(i+1);
	in_group = e1432_create_channel_group(hw, in_count, in_list);
	
	if (in_group >= 0)
	{
	    DEBUG((void) printf("e1432_create_channel_group returned %d\n",
				in_group));
	    return -1;
	}
    }
    else
    {
	(void) printf("ERROR: need at least 1 input for this program.\n");
	return -1;
    }

    /* Create source group */
    src_count = hwconfig[0].source_chans + hwconfig[1].source_chans;
    (void) printf("Source channels = %d\n", src_count);
    if ( src_count > 0)
    {
	if (src_count > SRC_MAX)
	    src_count = SRC_MAX;
	for (i = 0; i < src_count; i++)
	    src_list[i] = E1432_SOURCE_CHAN(i+1);
	src_group = e1432_create_channel_group(hw, src_count, src_list);
	if (src_group >= 0)
	{
	    DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    src_group));
	    return -1;
	}
    }
    else
    {
	(void) printf("ERROR: need at least 1 source for this program.\n");
	return -1;
    }

    /* Create global channel group */
    chan_count = 0;
    for (i = 0; i < in_count; i++)
    {
	chan_list[chan_count] = in_list[i];
	chan_count = chan_count+1;
    }
    for (i = 0; i < src_count; i++)
    {
	chan_list[chan_count] = src_list[i];
	chan_count = chan_count+1;
    }
    if (chan_count > 0)
    { 
	group = e1432_create_channel_group(hw, chan_count, chan_list);
	if (group >= 0)
	{
	    DEBUG((void) printf("e1432_create_channel_group returned %d\n",
				group));
	    return -1;
	}
 
    }

/* initialize inputs */
    if ( in_count > 0 )
    {
	CHECK(e1432_set_data_mode(hw, in_group, E1432_BLOCK_MODE));
	CHECK(e1432_set_span(hw, in_group, 20000));
	CHECK(e1432_set_blocksize(hw, in_group, 128));
	/*  CHECK(e1432_set_data_mode(hw, in_group,
	    E1432_CONTINUOUS_MODE)); */
    }
    
     
/* initialize source */
    if ( src_count > 0 )
    {
        CHECK(e1432_set_source_mode(hw, src_group,  E1432_SOURCE_MODE_RAND));
        CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
	CHECK(e1432_set_source_span(hw, src_group, 20000));
	CHECK(e1432_set_source_blocksize(hw, src_group, 1024));
	CHECK(e1432_set_range(hw, src_group, 1.0));
        CHECK(e1432_set_amp_scale(hw, src_group, .9995));
	CHECK(e1432_set_ramp_rate(hw, src_group, 0.0));
    }

/* initialize all channels */

    /* armmode = E1432_MANUAL_ARM; */
    /*    armmode = E1432_AUTO_ARM; */
armmode = E1432_AUTO_ARM;

    /* trigmode = E1432_MANUAL_TRIGGER; */
    /*    trigmode = E1432_AUTO_TRIGGER; */
trigmode = E1432_AUTO_TRIGGER;

    CHECK(e1432_set_auto_trigger(hw, group, trigmode));
    CHECK(e1432_set_auto_arm(hw, group, armmode));

    blockcountmax = 10;
    scan = 0;

/* Start measurement */
    
    for ( ; ; )
    {
	CHECK(e1432_reset_measure(hw, group));
	srcspan = 20000;
	srcblocksize = 4096;
	(void) printf("srcspan = %d\n",srcspan);
	(void) printf("srcblocksize = %d\n",srcblocksize);
	CHECK(e1432_set_source_span(hw, src_group, srcspan));
	CHECK(e1432_set_source_blocksize(hw, src_group, srcblocksize));
	CHECK(e1432_init_measure(hw, group));
	for (i = 0; i < blockcountmax; i++)
	{
	    scan = scan+1;
	    (void) printf("scan = %d\n",scan);

	    if (armmode == E1432_MANUAL_ARM)
	    {
		CHECK(e1432_arm_measure(hw, group, wait));
	    }

	    if (trigmode == E1432_MANUAL_TRIGGER)
	    {
		CHECK(e1432_trigger_measure(hw, group, nowait));
	    }

	    /* Wait for group block ready */
	    while (!(error = e1432_block_available(hw, in_group))); /* Note ; */
	    if (error < 0)
		(void) printf("e1432_block_available() failed, error: %d\n", error);

	    /* Block available flag true means the all channels have a block
	       ready.  Read all blocks of data by using the group ID */

	    CHECK(read_data());
	}
	
	CHECK(e1432_reset_measure(hw, group));
	srcspan = 5000;
	srcblocksize = 1024;
	(void) printf("srcspan = %d\n",srcspan);
	(void) printf("srcblocksize = %d\n",srcblocksize);
	CHECK(e1432_set_source_span(hw, src_group, srcspan));
	CHECK(e1432_set_source_blocksize(hw, src_group, srcblocksize));

	CHECK(e1432_init_measure(hw, group));
	for (i = 0; i < blockcountmax; i++)
	{
	    scan = scan+1;
	    (void) printf("scan = %d\n",scan);

	    if (armmode == E1432_MANUAL_ARM)
	    {
		CHECK(e1432_arm_measure(hw, group, wait));
	    }

	    if (trigmode == E1432_MANUAL_TRIGGER)
	    {
		CHECK(e1432_trigger_measure(hw, group, nowait));
	    }

	    /* Wait for group block ready */
	    while (!(error = e1432_block_available(hw, in_group))); /* Note ; */
	    if (error < 0)
		(void) printf("e1432_block_available() failed, error: %d\n", error);

	    /* Block available flag true means the all channels have a block
	       ready.  Read all blocks of data by using the group ID */

	    CHECK(read_data());
	}
	
    }
    
    /*NOTREACHED*/
    return 0;
}



